/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.domain.ResourceTreeNode;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.vo.ResourceVo;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resource"})
public class ResourceController {
    private static Logger logger = LoggerFactory.getLogger(ResourceController.class);
    @Autowired
    private SentinelApiClient httpFetcher;

    @GetMapping(value={"/machineResource.json"})
    public Result<List<ResourceVo>> fetchResourceChainListOfMachine(String ip, Integer port, String type, String searchKey) {
        if (StringUtil.isEmpty((String)ip) || port == null) {
            return Result.ofFail((int)-1, (String)"invalid param, give ip, port");
        }
        String ROOT = "root";
        String DEFAULT = "default";
        if (StringUtil.isEmpty((String)type)) {
            type = "root";
        }
        if ("root".equalsIgnoreCase(type) || "default".equalsIgnoreCase(type)) {
            List nodeVos = this.httpFetcher.fetchResourceOfMachine(ip, port.intValue(), type);
            if (nodeVos == null) {
                return Result.ofSuccess(null);
            }
            ResourceTreeNode treeNode = ResourceTreeNode.fromNodeVoList((List)nodeVos);
            treeNode.searchIgnoreCase(searchKey);
            return Result.ofSuccess((Object)ResourceVo.fromResourceTreeNode((ResourceTreeNode)treeNode));
        }
        List nodeVos = this.httpFetcher.fetchClusterNodeOfMachine(ip, port.intValue(), true);
        if (nodeVos == null) {
            return Result.ofSuccess(null);
        }
        if (StringUtil.isNotEmpty((String)searchKey)) {
            nodeVos = nodeVos.stream().filter(node -> node.getResource().toLowerCase().contains(searchKey.toLowerCase())).collect(Collectors.toList());
        }
        return Result.ofSuccess((Object)ResourceVo.fromNodeVoList((List)nodeVos));
    }
}

