/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.SystemRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
public class SystemController {
    private final Logger logger = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private RuleRepository<SystemRuleEntity, Long> repository;
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private AppManagement appManagement;

    private <R> Result<R> checkBasicParams(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (!this.appManagement.isValidMachineOfApp(app, ip)) {
            return Result.ofFail((int)-1, (String)"given ip does not belong to given app");
        }
        if (port <= 0 || port > 65535) {
            return Result.ofFail((int)-1, (String)"port should be in (0, 65535)");
        }
        return null;
    }

    @GetMapping(value={"/rules.json"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<SystemRuleEntity>> apiQueryMachineRules(String app, String ip, Integer port) {
        Result checkResult = this.checkBasicParams(app, ip, port);
        if (checkResult != null) {
            return checkResult;
        }
        try {
            List rules = this.sentinelApiClient.fetchSystemRuleOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            this.logger.error("Query machine system rules error", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    private int countNotNullAndNotNegative(Number ... values) {
        int notNullCount = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i].doubleValue() >= 0.0)) continue;
            ++notNullCount;
        }
        return notNullCount;
    }

    @RequestMapping(value={"/new.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<SystemRuleEntity> apiAdd(String app, String ip, Integer port, Double highestSystemLoad, Double highestCpuUsage, Long avgRt, Long maxThread, Double qps) {
        Result checkResult = this.checkBasicParams(app, ip, port);
        if (checkResult != null) {
            return checkResult;
        }
        int notNullCount = this.countNotNullAndNotNegative(new Number[]{highestSystemLoad, avgRt, maxThread, qps, highestCpuUsage});
        if (notNullCount != 1) {
            return Result.ofFail((int)-1, (String)("only one of [highestSystemLoad, avgRt, maxThread, qps,highestCpuUsage] value must be set > 0, but " + notNullCount + " values get"));
        }
        if (null != highestCpuUsage && highestCpuUsage > 1.0) {
            return Result.ofFail((int)-1, (String)"highestCpuUsage must between [0.0, 1.0]");
        }
        SystemRuleEntity entity = new SystemRuleEntity();
        entity.setApp(app.trim());
        entity.setIp(ip.trim());
        entity.setPort(port);
        if (null != highestSystemLoad) {
            entity.setHighestSystemLoad(highestSystemLoad);
        } else {
            entity.setHighestSystemLoad(Double.valueOf(-1.0));
        }
        if (null != highestCpuUsage) {
            entity.setHighestCpuUsage(highestCpuUsage);
        } else {
            entity.setHighestCpuUsage(Double.valueOf(-1.0));
        }
        if (avgRt != null) {
            entity.setAvgRt(avgRt);
        } else {
            entity.setAvgRt(Long.valueOf(-1L));
        }
        if (maxThread != null) {
            entity.setMaxThread(maxThread);
        } else {
            entity.setMaxThread(Long.valueOf(-1L));
        }
        if (qps != null) {
            entity.setQps(qps);
        } else {
            entity.setQps(Double.valueOf(-1.0));
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (SystemRuleEntity)this.repository.save((Object)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("Add SystemRule error", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, ip, port)) {
            this.logger.warn("Publish system rules fail after rule add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @GetMapping(value={"/save.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<SystemRuleEntity> apiUpdateIfNotNull(Long id, String app, Double highestSystemLoad, Double highestCpuUsage, Long avgRt, Long maxThread, Double qps) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        SystemRuleEntity entity = (SystemRuleEntity)this.repository.findById((Object)id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " dose not exist"));
        }
        if (StringUtil.isNotBlank((String)app)) {
            entity.setApp(app.trim());
        }
        if (highestSystemLoad != null) {
            if (highestSystemLoad < 0.0) {
                return Result.ofFail((int)-1, (String)"highestSystemLoad must >= 0");
            }
            entity.setHighestSystemLoad(highestSystemLoad);
        }
        if (highestCpuUsage != null) {
            if (highestCpuUsage < 0.0) {
                return Result.ofFail((int)-1, (String)"highestCpuUsage must >= 0");
            }
            if (highestCpuUsage > 1.0) {
                return Result.ofFail((int)-1, (String)"highestCpuUsage must <= 1");
            }
            entity.setHighestCpuUsage(highestCpuUsage);
        }
        if (avgRt != null) {
            if (avgRt < 0L) {
                return Result.ofFail((int)-1, (String)"avgRt must >= 0");
            }
            entity.setAvgRt(avgRt);
        }
        if (maxThread != null) {
            if (maxThread < 0L) {
                return Result.ofFail((int)-1, (String)"maxThread must >= 0");
            }
            entity.setMaxThread(maxThread);
        }
        if (qps != null) {
            if (qps < 0.0) {
                return Result.ofFail((int)-1, (String)"qps must >= 0");
            }
            entity.setQps(qps);
        }
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (SystemRuleEntity)this.repository.save((Object)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("save error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.info("publish system rules fail after rule update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @RequestMapping(value={"/delete.json"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<?> delete(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        SystemRuleEntity oldEntity = (SystemRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete((Object)id);
        }
        catch (Throwable throwable) {
            this.logger.error("delete error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.info("publish system rules fail after rule delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.sentinelApiClient.setSystemRuleOfMachine(app, ip, port.intValue(), rules);
    }
}

