/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller.gateway;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.ApiDefinitionEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.ApiPredicateItemEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.api.AddApiReqVo;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.api.ApiPredicateItemVo;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.api.UpdateApiReqVo;
import com.alibaba.csp.sentinel.dashboard.repository.gateway.InMemApiDefinitionStore;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gateway/api"})
public class GatewayApiController {
    private final Logger logger = LoggerFactory.getLogger(GatewayApiController.class);
    @Autowired
    private InMemApiDefinitionStore repository;
    @Autowired
    private SentinelApiClient sentinelApiClient;

    @GetMapping(value={"/list.json"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<ApiDefinitionEntity>> queryApis(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        try {
            List apis = (List)this.sentinelApiClient.fetchApis(app, ip, port.intValue()).get();
            this.repository.saveAll(apis);
            return Result.ofSuccess((Object)apis);
        }
        catch (Throwable throwable) {
            this.logger.error("queryApis error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    @PostMapping(value={"/new.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<ApiDefinitionEntity> addApi(HttpServletRequest request, @RequestBody AddApiReqVo reqVo) {
        String app = reqVo.getApp();
        if (StringUtil.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        ApiDefinitionEntity entity = new ApiDefinitionEntity();
        entity.setApp(app.trim());
        String ip = reqVo.getIp();
        if (StringUtil.isBlank((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        entity.setIp(ip.trim());
        Integer port = reqVo.getPort();
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        entity.setPort(port);
        String apiName = reqVo.getApiName();
        if (StringUtil.isBlank((String)apiName)) {
            return Result.ofFail((int)-1, (String)"apiName can't be null or empty");
        }
        entity.setApiName(apiName.trim());
        List predicateItems = reqVo.getPredicateItems();
        if (CollectionUtils.isEmpty((Collection)predicateItems)) {
            return Result.ofFail((int)-1, (String)"predicateItems can't empty");
        }
        ArrayList<ApiPredicateItemEntity> predicateItemEntities = new ArrayList<ApiPredicateItemEntity>();
        for (ApiPredicateItemVo predicateItem : predicateItems) {
            ApiPredicateItemEntity predicateItemEntity = new ApiPredicateItemEntity();
            Integer matchStrategy = predicateItem.getMatchStrategy();
            if (!Arrays.asList(0, 1, 2).contains(matchStrategy)) {
                return Result.ofFail((int)-1, (String)("invalid matchStrategy: " + matchStrategy));
            }
            predicateItemEntity.setMatchStrategy(matchStrategy);
            String pattern = predicateItem.getPattern();
            if (StringUtil.isBlank((String)pattern)) {
                return Result.ofFail((int)-1, (String)"pattern can't be null or empty");
            }
            predicateItemEntity.setPattern(pattern);
            predicateItemEntities.add(predicateItemEntity);
        }
        entity.setPredicateItems(new LinkedHashSet(predicateItemEntities));
        List allApis = this.repository.findAllByMachine(MachineInfo.of((String)app.trim(), (String)ip.trim(), (Integer)port));
        if (allApis.stream().map(o -> o.getApiName()).anyMatch(o -> o.equals(apiName.trim()))) {
            return Result.ofFail((int)-1, (String)("apiName exists: " + apiName));
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (ApiDefinitionEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("add gateway api error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishApis(app, ip, port)) {
            this.logger.warn("publish gateway apis fail after add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @PostMapping(value={"/save.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<ApiDefinitionEntity> updateApi(@RequestBody UpdateApiReqVo reqVo) {
        String app = reqVo.getApp();
        if (StringUtil.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        Long id = reqVo.getId();
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        ApiDefinitionEntity entity = (ApiDefinitionEntity)this.repository.findById(id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("api does not exist, id=" + id));
        }
        List predicateItems = reqVo.getPredicateItems();
        if (CollectionUtils.isEmpty((Collection)predicateItems)) {
            return Result.ofFail((int)-1, (String)"predicateItems can't empty");
        }
        ArrayList<ApiPredicateItemEntity> predicateItemEntities = new ArrayList<ApiPredicateItemEntity>();
        for (ApiPredicateItemVo predicateItem : predicateItems) {
            ApiPredicateItemEntity predicateItemEntity = new ApiPredicateItemEntity();
            int matchStrategy = predicateItem.getMatchStrategy();
            if (!Arrays.asList(0, 1, 2).contains(matchStrategy)) {
                return Result.ofFail((int)-1, (String)("Invalid matchStrategy: " + matchStrategy));
            }
            predicateItemEntity.setMatchStrategy(Integer.valueOf(matchStrategy));
            String pattern = predicateItem.getPattern();
            if (StringUtil.isBlank((String)pattern)) {
                return Result.ofFail((int)-1, (String)"pattern can't be null or empty");
            }
            predicateItemEntity.setPattern(pattern);
            predicateItemEntities.add(predicateItemEntity);
        }
        entity.setPredicateItems(new LinkedHashSet(predicateItemEntities));
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (ApiDefinitionEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("update gateway api error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishApis(app, entity.getIp(), entity.getPort())) {
            this.logger.warn("publish gateway apis fail after update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @PostMapping(value={"/delete.json"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> deleteApi(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        ApiDefinitionEntity oldEntity = (ApiDefinitionEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Throwable throwable) {
            this.logger.error("delete gateway api error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishApis(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.warn("publish gateway apis fail after delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishApis(String app, String ip, Integer port) {
        List apis = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.sentinelApiClient.modifyApis(app, ip, port.intValue(), apis);
    }
}

