/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPathPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.ApiPredicateItemEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.slots.block.Rule;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ApiDefinitionEntity
implements RuleEntity {
    private Long id;
    private String app;
    private String ip;
    private Integer port;
    private Date gmtCreate;
    private Date gmtModified;
    private String apiName;
    private Set<ApiPredicateItemEntity> predicateItems;

    public static ApiDefinitionEntity fromApiDefinition(String app, String ip, Integer port, ApiDefinition apiDefinition) {
        ApiDefinitionEntity entity = new ApiDefinitionEntity();
        entity.setApp(app);
        entity.setIp(ip);
        entity.setPort(port);
        entity.setApiName(apiDefinition.getApiName());
        LinkedHashSet<ApiPredicateItemEntity> predicateItems = new LinkedHashSet<ApiPredicateItemEntity>();
        entity.setPredicateItems(predicateItems);
        Set apiPredicateItems = apiDefinition.getPredicateItems();
        if (apiPredicateItems != null) {
            for (ApiPredicateItem apiPredicateItem : apiPredicateItems) {
                ApiPredicateItemEntity itemEntity = new ApiPredicateItemEntity();
                predicateItems.add(itemEntity);
                ApiPathPredicateItem pathPredicateItem = (ApiPathPredicateItem)apiPredicateItem;
                itemEntity.setPattern(pathPredicateItem.getPattern());
                itemEntity.setMatchStrategy(Integer.valueOf(pathPredicateItem.getMatchStrategy()));
            }
        }
        return entity;
    }

    public ApiDefinition toApiDefinition() {
        ApiDefinition apiDefinition = new ApiDefinition();
        apiDefinition.setApiName(this.apiName);
        LinkedHashSet<ApiPathPredicateItem> apiPredicateItems = new LinkedHashSet<ApiPathPredicateItem>();
        apiDefinition.setPredicateItems(apiPredicateItems);
        if (this.predicateItems != null) {
            for (ApiPredicateItemEntity predicateItem : this.predicateItems) {
                ApiPathPredicateItem apiPredicateItem = new ApiPathPredicateItem();
                apiPredicateItems.add(apiPredicateItem);
                apiPredicateItem.setMatchStrategy(predicateItem.getMatchStrategy().intValue());
                apiPredicateItem.setPattern(predicateItem.getPattern());
            }
        }
        return apiDefinition;
    }

    public ApiDefinitionEntity() {
    }

    public ApiDefinitionEntity(String apiName, Set<ApiPredicateItemEntity> predicateItems) {
        this.apiName = apiName;
        this.predicateItems = predicateItems;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public Set<ApiPredicateItemEntity> getPredicateItems() {
        return this.predicateItems;
    }

    public void setPredicateItems(Set<ApiPredicateItemEntity> predicateItems) {
        this.predicateItems = predicateItems;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Rule toRule() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDefinitionEntity entity = (ApiDefinitionEntity)o;
        return Objects.equals(this.id, entity.id) && Objects.equals(this.app, entity.app) && Objects.equals(this.ip, entity.ip) && Objects.equals(this.port, entity.port) && Objects.equals(this.gmtCreate, entity.gmtCreate) && Objects.equals(this.gmtModified, entity.gmtModified) && Objects.equals(this.apiName, entity.apiName) && Objects.equals(this.predicateItems, entity.predicateItems);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.app, this.ip, this.port, this.gmtCreate, this.gmtModified, this.apiName, this.predicateItems);
    }

    public String toString() {
        return "ApiDefinitionEntity{id=" + this.id + ", app='" + this.app + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", apiName='" + this.apiName + '\'' + ", predicateItems=" + this.predicateItems + '}';
    }
}

